import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/util.dart';
import 'package:viser_remit/data/controller/send_money_history/send_money_history_controller.dart';
import 'package:viser_remit/data/repo/send_money_history/send_money_history_repo.dart';
import 'package:viser_remit/view/components/app-bar/viser_remit_app_bar.dart';
import 'package:viser_remit/view/components/custom_loader/custom_loader.dart';
import 'package:viser_remit/view/components/status/history_status_section.dart';

import '../../../core/utils/dimensions.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/style.dart';
import '../../../data/services/api_client.dart';
import '../../components/custom_no_data_found_class.dart';

class SendMoneyHistory extends StatefulWidget {
  const SendMoneyHistory({super.key});

  @override
  State<SendMoneyHistory> createState() => _SendMoneyHistoryState();
}

class _SendMoneyHistoryState extends State<SendMoneyHistory> {
  bool leadingStatus = false;

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(SendMoneyHistoryRepo(apiClient: Get.find()));
    final controller = Get.put(SendMoneyHistoryController(sendMoneyHistoryRepo: Get.find()));
    leadingStatus = Get.arguments ?? false;
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadSendMoneyHistoryData();
    });
  }

  @override
  Widget build(BuildContext context) {
    Get.find<ApiClient>();

    return GetBuilder<SendMoneyHistoryController>(
      builder: (controller) => Scaffold(
        appBar: ViserRemitAppBar(
          title: MyStrings.sendMoneyHistory.tr,
          isElevation: true,
          isShowLeading: leadingStatus,
        ),
        body: controller.isLoading
            ? const CustomLoader()
            : SingleChildScrollView(
                physics: const BouncingScrollPhysics(),
                padding: const EdgeInsets.symmetric(horizontal: Dimensions.space14),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(height: Dimensions.space28),
                    controller.sendMoneyHistoryList.isEmpty
                        ? const NoDataOrInternetScreen()
                        : Column(
                            children: List.generate(controller.sendMoneyHistoryList.length, (index) {
                              var sendMoneyHistoryList = controller.sendMoneyHistoryList[index];

                              return GestureDetector(
                                onTap: () {
                                  Get.toNamed(RouteHelper.sendMoneyHistoryDetailsScreen);
                                  controller.setCurrentIndex(index);
                                },
                                child: Container(
                                  padding: const EdgeInsets.symmetric(horizontal: 13, vertical: 16),
                                  margin: const EdgeInsetsDirectional.only(bottom: 10),
                                  decoration: BoxDecoration(
                                    border: const Border(left: BorderSide(color: MyColor.primaryColor,width: 1.5)),
                                    borderRadius: BorderRadius.circular(8),
                                    // boxShadow: MyUtils.getShadow(),
                                    color: MyColor.colorWhite,
                                    boxShadow: MyUtils.getCardShadow()
                                  ),
                                  child: Row(
                                    children: [
                                      Expanded(
                                        flex: 5,
                                        child: Column(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            Row(
                                              children: [
                                                Text(MyStrings.mtcn.tr, style: semiBoldDefault),
                                                Text(
                                                  " #${sendMoneyHistoryList.mtcnNumber}",
                                                  style: boldSmall.copyWith(color: MyColor.bodyTextColor),
                                                ),
                                              ],
                                            ),

                                            const SizedBox(height: Dimensions.space12),

                                            Column(
                                              crossAxisAlignment: CrossAxisAlignment.start,
                                              children: [
                                                Text(MyStrings.amount.tr, style: semiBoldLarge),
                                                const SizedBox(height: Dimensions.space5),
                                                Text(
                                                  "${Converter.formatNumber(sendMoneyHistoryList.sendingAmount.toString())} "
                                                      "${sendMoneyHistoryList.sendingCurrency} → "
                                                      "${Converter.formatNumber(sendMoneyHistoryList.recipientAmount.toString())}"
                                                      "${sendMoneyHistoryList.recipientCurrency}",
                                                  style: boldSmall.copyWith(color: MyColor.bodyTextColor),
                                                ),

                                              ],
                                            )
                                          ],
                                        ),
                                      ),
                                      // const SizedBox(width: Dimensions.space24),

                                      Expanded(
                                        flex: 3,
                                        child: Align(
                                          alignment: Alignment.centerRight,
                                          child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.end,
                                            children: [
                                              HistoryStatusSection(status: sendMoneyHistoryList.paymentStatus.toString(), isDepositAvailable: sendMoneyHistoryList.deposit == null ? false : true),
                                              const SizedBox(height: Dimensions.space3),
                                              Text("${MyStrings.charge }: ${Converter.formatNumber(sendMoneyHistoryList.sendingCharge.toString())} ${sendMoneyHistoryList.sendingCurrency}", style: boldSmall.copyWith(color: MyColor.colorRed)),
                                              const SizedBox(height: Dimensions.space12),
                                              Row(
                                                mainAxisSize: MainAxisSize.min,
                                                children: [
                                                  Text(MyStrings.viewDetails.tr,style: regularLarge.copyWith(color: MyColor.colorBlack),),
                                                  const Icon(Icons.arrow_forward_ios,size: 10,)
                                                ],
                                              )
                                            ],
                                          ),
                                        )
                                      ),

                                    ],
                                  ),
                                ),
                              );
                            }),
                          ),
                  ],
                ),
              ),
      ),
    );
  }
}
